﻿using System;

namespace gov.va.med.vbecs.Common.Log
{
    /// <summary>
    /// ILogger
    /// </summary>
    public interface ILogger
    {
        /// <summary>
        /// Debug
        /// </summary>
        /// <param name="message"></param>
        void Debug(object message);

        /// <summary>
        /// IsDebugEnabled
        /// </summary>
        bool IsDebugEnabled { get; }

        /// <summary>
        /// Info
        /// </summary>
        /// <param name="message"></param>
        void Info(object message);

        /// <summary>
        /// IsInfoEnabled
        /// </summary>
        bool IsInfoEnabled { get; }

        /// <summary>
        /// Warn
        /// </summary>
        /// <param name="message"></param>
        void Warn(object message);

        /// <summary>
        /// IsWarnEnabled
        /// </summary>
        bool IsWarnEnabled { get; }

        /// <summary>
        /// Error
        /// </summary>
        /// <param name="message"></param>
        void Error(object message);


        /// <summary>
        /// Error
        /// </summary>
        /// <param name="message"></param>
        /// <param name="ex"></param>
        void Error(object message, Exception ex);

        /// <summary>
        /// IsErrorEnabled
        /// </summary>
        bool IsErrorEnabled { get; }

        /// <summary>
        /// Fatal
        /// </summary>
        /// <param name="message"></param>
        void Fatal(object message);

        /// <summary>
        /// IsFatalEnabled
        /// </summary>
        bool IsFatalEnabled { get; }
    }
}
